library(HMM)

##################################################################
##simu.HMM is a function used to simulate time course microarray##
##data.                                                         ##
##n -- number of "genes"                                        ##
##num.time -- number of time points                             ##
##p0 -- proportion of DE genes at the first time point          ##
##transit -- probability from EE or DD to DE                    ##
##################################################################
simu.HMM<-function(n=2000,num.time=6,p0=0.1,transit=c(0.1,0.1)) {
  ptns<-matrix(0,nrow=n,ncol=num.time)
  ptns[,1]<-rbinom(n,1,p0)
  for (days in 2:num.time) {
    for (i in 1:n) {
      ptns[i,days]<-rbinom(1,1,transit[ptns[i,days-1]+1])
    }
  }

  eset<-NULL
  
  for (days in 1:num.time) {
    lbd<-matrix(0,n,2)

    lbd[,1]<-rgamma(n,shape=0.9,rate=0.5)
    lbd[,2]<-rgamma(n,shape=0.9,rate=0.5)

    x<-matrix(0,n,2)

    x[,1]<-rgamma(n,shape=10,rate=lbd[,1])
    x[,2]<-rgamma(n,shape=10,rate=lbd[,1])

    x[(ptns[,days]==1),2]<-rgamma(sum(ptns[,days]),shape=10,rate=lbd[(ptns[,days]==1),2])
    
    eset<-cbind(eset,x)
  }
  
  return(list(eset=eset,ptns=ptns))
}

set.seed(123)
exam<-simu.HMM(transit=c(0.1,0.5))
eset <- exam$eset

x<-vector("list",1)
x[[1]]<-c("1 1","1 2")
patterns<-HMM.ebPatterns(c(1,1,2,2,3,3,4,4,5,5,6,6),x,ordered=FALSE)

gg1.fit<-emfit(data=eset,family="GG",hypothese=patterns,theta.init = c(1, 1, 1), p.init = c(0.5,0.5),num.iter=10)

##display the result
show(gg1.fit)


