\name{emfit}
\alias{emfit}
\alias{emfit,exprSet,character,HMM.ebarraysPatterns-method}
\alias{emfit,exprSet,ebarraysFamily,HMM.ebarraysPatterns-method}
\alias{emfit,matrix,character,HMM.ebarraysPatterns-method}
\alias{emfit,matrix,ebarraysFamily,HMM.ebarraysPatterns-method}
\alias{show,ebarraysEmFit-method}
\alias{ebarraysEmFit-class}
\title{ Implements EM algorithm for hidden Markov models }
\description{
  Implements the EM algorithm for hidden Markov models
}
\usage{
emfit(data,
      family,
      hypotheses,
      theta.init, p.init,
      num.iter = 20,
      verbose = getOption("verbose"),
      trace = TRUE,
      optim.control = list())
}
\arguments{
  \item{data}{ a matrix or an an object of class ``exprSet''}
  \item{family}{
    an object of class ``ebarraysFamily'' or a characterstring which can
    be coerced to one. Currently, only the characters "GG" and "LNN" are
    valid. Other families can be supplied by constructing them
    explicitly.
  }
  \item{hypotheses}{
    an object of class ``HMM.ebarraysPatterns'' representing the hypotheses
    of interest. Such patterns can be generated by the function
    \code{\link{HMM.ebPatterns}}
  }
  \item{theta.init} { initial value for parameters, default is NULL }
  \item{p.init} {inital value for probabilities of differential
    expression pattern, default is NULL }
  \item{num.iter}{ number of EM iterations}
  \item{verbose}{ logical or numeric (0,1,2) indicating desired level of
    information printed for the user}
  \item{trace} {whether or not the trace of the EM iterations is to be
    saved }
  \item{optim.control}{ list passed unchanged to \code{\link{optim}} for
    finer control}
}
\value{
  an object of class ``HMM.ebarraysEMfit'', that can be summarized by
  \code{show()}
}

\references{

    Yuan, M. and Kendziorski, C. (2005), Hidden Markov Models for
    Microarray Time Course Data under Multiple Biological Conditions
    (with discussion), to appear in Journal of the American Statistical
    Association. (\url{http://www.isye.gatech.edu/~myuan/})
}
\author{Ming Yuan}
\seealso{
  \code{\link{HMM.ebPatterns}}, \code{\link{ebarraysFamily-class}}
}
\examples{
demo(hmm)
}
\keyword{models}

