\name{utilities}
\alias{utilities}
\alias{output}
\alias{HMM.ebPatterns}
\title{Utility functions for the HMMarrays package}
\description{
  Utilitiy functions for the HMMarrays package
}
\usage{
output(fit,dir="./",pp.path=FALSE)
HMM.ebPatterns(time,x,ordered=F,homo=FALSE,independent=FALSE)
}
\arguments{
  \item{fit}{ object returned by \code{emfit}}
  \item{dir}{ directory where the results are to be saved}
  \item{pp.path} {whether or not the posterior probabilites of each
    possible path are to be saved}
  \item{time} { a vector of time points which the replicates correspond to }
  \item{x}{
    x can be a character vector (of length > 2) (see example), or an
    arbitrary connection which should provide patterns, one line for
    each pattern. If \code{x} is a character vector of length 1, it is
    assumed to be the name of a file (since there's no point in a
    patterns object with only one pattern) which is then opened and
    treated as a connection.
  }
  \item{ordered}{ logical variable specifying whether the pattern is
    ordered or not}
  \item{homo} { whether or not the HMM is homogeneous}
  \item{independent} {whether or not the measurement under each time
    point is independent}
}
\details{
  \code{output} save the results from the HMM analysis.
  \code{HMM.ebPatterns} creates objects that represent a collection of
  hypotheses to be used by \code{emfit}.
}

\value{
  \code{HMM.ebPatterns} creates an Object of class ``HMM.ebarraysPatterns'', to
  be used in other functions such as \code{\link{emfit}}.

}
\seealso{\code{\link{emfit}}}
\author{Ming Yuan}
\examples{
  demo(hmm)
}
\keyword{models}



